#include <cstring>
#include <cstdio>
#include <bits/stdc++.h>
using namespace std;

const int mxN = 5005;
int trie[mxN * 31][2];
int cnt[mxN * 31];

int koren = 0;
int sledeciIndeks = 0;

void insert(int x) {
    int tren = koren;

    for(int i = 29; i >= 0; --i) {
        int vred = (x >> i) & 1;

        if(trie[tren][vred] == -1) {
            trie[tren][vred] = ++sledeciIndeks;
        }

        tren = trie[tren][vred];
        ++cnt[tren];
    }
}

void erase(int x) {
    int tren = koren;

    for(int i = 29; i >= 0; --i) {
        int vred = (x >> i) & 1;
        tren = trie[tren][vred];
        --cnt[tren];
    }
}

int find(int x) {
    int tren = koren;

    int odg = 0;

    for(int i = 29; i >= 0; --i) {
        int vred = (x >> i) & 1;

        int novi = trie[tren][vred];
        if(cnt[novi] > 0) {
            tren = trie[tren][novi];
            odg ^= (vred << i);
        } else {
            if(trie[tren][vred ^ 1] == -1 || cnt[trie[tren][vred ^ 1]] == 0) {
                return -1;
            }
            tren = trie[tren][novi];
            odg ^= ((vred ^ 1) << i);
        }
    }

    return odg;
}

void Resi(int N, int *A, int Q, int *T, int *I, int *X, bool *O) {
    for(int i = 0; i < mxN * 31; ++i) {
        trie[i][0] = trie[i][1] = -1;
        cnt[i] = 0;
    }

    for(int i = 1; i <= Q; ++i) {
        if(T[i] == 1) {
            A[I[i]] = X[i];
        } else {
            int l = I[i];
            int r = I[i] + X[i] - 1;

            int mini = INT_MAX;

            for(int j = l; j <= r; ++j) {
                mini = min(mini, A[j]);
                insert(A[j]);
            }

            vector<int> pref;
            pref.push_back(mini);
            erase(mini);

            bool dobar = true;

            for(int j = l + 1; j <= r; ++j) {
                int naj = find(pref.back());
                if(naj == -1) {
                    dobar = false;
                    break;
                }

                pref.push_back(pref.back() ^ naj);
                erase(naj);
            }

            if(dobar) {
                O[i] = is_sorted(pref.begin(), pref.end());
            }
        }
    }
}